package gov.va.med.mhv.common.data.converter;

import gov.va.med.mhv.common.api.dto.FacilityDTO;
import gov.va.med.mhv.common.data.model.Facility;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FacilityConverter {
	
	@Autowired
	private FacilityInfoConveter facilityInfoConveter;
	
	public FacilityDTO convertDomainFacility(Facility facility) {
		FacilityDTO facilityDto = new FacilityDTO();
		
		facilityDto.setId(facility.getId());
		facilityDto.setOplock(facility.getOplock());
		facilityDto.setName(facility.getName());
		facilityDto.setPatientId(facility.getPatientId());
		facilityDto.setIdentifier(facility.getIdentifier());
		facilityDto.setFacilityInfoId(facility.getFacilityInfoId());
		
		if (null != facility.getFacilityInfo()) {
			facilityDto.setFacilityInfo(facilityInfoConveter.convertDomainFacilityInfo(facility.getFacilityInfo()));
		}
		
		return facilityDto;
	}
	
	public Facility coonvertDTOFacility(FacilityDTO facilityDto){
		Facility facility = new Facility();
		
		facility.setId(facilityDto.getId());
		facility.setOplock(facilityDto.getOplock());
		facility.setName(facilityDto.getName());
		facility.setPatientId(facilityDto.getPatientId());
		facility.setIdentifier(facilityDto.getIdentifier());
		facility.setFacilityInfoId(facilityDto.getFacilityInfoId());
		
		return facility;
	}
}
